﻿-- Path of Building
--
-- Module: Calc Sections
-- List of sections for the Calcs tab
--

-- Commonly used modifier lists
local physicalHitTaken = {
	"DamageTaken", "PhysicalDamageTaken"
}
local lightningHitTaken = {
	"DamageTaken", "LightningDamageTaken", "ElementalDamageTaken", "LightningResist", "ElementalResist"
}
local coldHitTaken = {
	"DamageTaken", "ColdDamageTaken", "ElementalDamageTaken", "ColdResist", "ElementalResist"
}
local fireHitTaken = {
	"DamageTaken", "FireDamageTaken", "ElementalDamageTaken", "FireResist", "ElementalResist"
}
local chaosHitTaken = {
	"DamageTaken", "ChaosDamageTaken", "ChaosResist"
}
local physicalConvert = { 
	"SkillPhysicalDamageConvertToLightning", "SkillPhysicalDamageConvertToCold", "SkillPhysicalDamageConvertToFire", "SkillPhysicalDamageConvertToChaos", 
	"PhysicalDamageConvertToLightning", "PhysicalDamageConvertToCold", "PhysicalDamageConvertToFire", "PhysicalDamageConvertToChaos", "NonChaosDamageConvertToChaos", 
	"PhysicalDamageGainAsLightning", "PhysicalDamageGainAsCold", "PhysicalDamageGainAsFire", "PhysicalDamageGainAsChaos", "NonChaosDamageGainAsChaos" 
}
local lightningConvert = {
	"SkillLightningDamageConvertToCold", "SkillLightningDamageConvertToFire", "SkillLightningDamageConvertToChaos",
	"LightningDamageConvertToCold", "LightningDamageConvertToFire", "LightningDamageConvertToChaos", "ElementalDamageConvertToChaos", "NonChaosDamageConvertToChaos", 
	"LightningDamageGainAsCold", "LightningDamageGainAsFire", "LightningDamageGainAsChaos", "ElementalDamageGainAsChaos", "NonChaosDamageGainAsChaos"
}
local coldConvert = { 
	"SkillColdDamageConvertToFire", "SkillColdDamageConvertToChaos",
	"ColdDamageConvertToFire", "ColdDamageConvertToChaos", "ElementalDamageConvertToChaos", "NonChaosDamageConvertToChaos",
	"ColdDamageGainAsFire", "ColdDamageGainAsChaos", "ElementalDamageGainAsChaos", "NonChaosDamageGainAsChaos"
}
local fireConvert = {
	"SkillFireDamageConvertToChaos",
	"FireDamageConvertToChaos", "ElementalDamageConvertToChaos", "NonChaosDamageConvertToChaos", 
	"FireDamageGainAsChaos", "ElementalDamageGainAsChaos", "NonChaosDamageGainAsChaos"
}

return {
{ 3, "HitDamage", 1, "技能击中伤害", colorCodes.OFFENCE, {
	extra = "{output:DisplayDamage}",
	flag = "hit",
	colWidth = 95,
	{
{ format = "所有:", },
{ format = "物理:" },
{ format = "闪电:" },
{ format = "冰霜:" },
{ format = "火焰:" },
{ format = "混沌:" },
	},
{ label = "附加 Min",
		{ },
		{ format = "{0:mod:1,2}", 
			{ label = "Player modifiers", modName = "PhysicalMin", modType = "BASE", cfg = "skill" },
			{ label = "Enemy modifiers", modName = "SelfPhysicalMin", modType = "BASE", enemy = true, cfg = "skill" },
		},
		{ format = "{0:mod:1,2}", 
			{ label = "Player modifiers", modName = "LightningMin", modType = "BASE", cfg = "skill" },
			{ label = "Enemy modifiers", modName = "SelfLightningMin", modType = "BASE", enemy = true, cfg = "skill" },
		},
		{ format = "{0:mod:1,2}", 
			{ label = "Player modifiers", modName = "ColdMin", modType = "BASE", cfg = "skill" },
			{ label = "Enemy modifiers", modName = "SelfColdMin", modType = "BASE", enemy = true, cfg = "skill" },
		},
		{ format = "{0:mod:1,2}", 
			{ label = "Player modifiers", modName = "FireMin", modType = "BASE", cfg = "skill" },
			{ label = "Enemy modifiers", modName = "SelfFireMin", modType = "BASE", enemy = true, cfg = "skill" },
		},
		{ format = "{0:mod:1,2}", 
			{ label = "Player modifiers", modName = "ChaosMin", modType = "BASE", cfg = "skill" },
			{ label = "Enemy modifiers", modName = "SelfChaosMin", modType = "BASE", enemy = true, cfg = "skill" },
		},
	},
{ label = "附加 Max",
		{ },
		{ format = "{0:mod:1,2}", 
			{ label = "Player modifiers", modName = "PhysicalMax", modType = "BASE", cfg = "skill" },
			{ label = "Enemy modifiers", modName = "SelfPhysicalMax", modType = "BASE", enemy = true, cfg = "skill" },
		},
		{ format = "{0:mod:1,2}", 
			{ label = "Player modifiers", modName = "LightningMax", modType = "BASE", cfg = "skill" },
			{ label = "Enemy modifiers", modName = "SelfLightningMax", modType = "BASE", enemy = true, cfg = "skill" },
		},
		{ format = "{0:mod:1,2}", 
			{ label = "Player modifiers", modName = "ColdMax", modType = "BASE", cfg = "skill" },
			{ label = "Enemy modifiers", modName = "SelfColdMax", modType = "BASE", enemy = true, cfg = "skill" },
		},
		{ format = "{0:mod:1,2}", 
			{ label = "Player modifiers", modName = "FireMax", modType = "BASE", cfg = "skill" },
			{ label = "Enemy modifiers", modName = "SelfFireMax", modType = "BASE", enemy = true, cfg = "skill" },
		},
		{ format = "{0:mod:1,2}", 
			{ label = "Player modifiers", modName = "ChaosMax", modType = "BASE", cfg = "skill" },
			{ label = "Enemy modifiers", modName = "SelfChaosMax", modType = "BASE", enemy = true, cfg = "skill" },
		},
	},
	-- Skill Hit Damage
{ label = "所有的【提高】", notFlag = "attack",
		{ format = "{0:mod:1}%", { modName = "Damage", modType = "INC", cfg = "skill" }, },
		{ format = "{0:mod:1}%", { modName = "PhysicalDamage", modType = "INC", cfg = "skill" }, },
		{ format = "{0:mod:1}%", { modName = { "LightningDamage", "ElementalDamage" }, modType = "INC", cfg = "skill" }, },
		{ format = "{0:mod:1}%", { modName = { "ColdDamage", "ElementalDamage" }, modType = "INC", cfg = "skill" }, },
		{ format = "{0:mod:1}%", { modName = { "FireDamage", "ElementalDamage" }, modType = "INC", cfg = "skill" }, },
		{ format = "{0:mod:1}%", { modName = "ChaosDamage", modType = "INC", cfg = "skill" }, },
	},
{ label = "所有的【额外提高】", notFlag = "attack",
		{ format = "{0:mod:1}%", { modName = "Damage", modType = "MORE", cfg = "skill" }, },
		{ format = "{0:mod:1}%", { modName = "PhysicalDamage", modType = "MORE", cfg = "skill" }, },
		{ format = "{0:mod:1}%", { modName = { "LightningDamage", "ElementalDamage" }, modType = "MORE", cfg = "skill" }, },
		{ format = "{0:mod:1}%", { modName = { "ColdDamage", "ElementalDamage" }, modType = "MORE", cfg = "skill" }, },
		{ format = "{0:mod:1}%", { modName = { "FireDamage", "ElementalDamage" }, modType = "MORE", cfg = "skill" }, },
		{ format = "{0:mod:1}%", { modName = "ChaosDamage", modType = "MORE", cfg = "skill" }, },
	},
{ label = "有效 DPS Mod", notFlag = "attack", flag = "effective",
		{ },
		{ format = "x {3:output:PhysicalEffMult}",
			{ breakdown = "PhysicalEffMult" },
{ label = "敌人加成", modName = physicalHitTaken, enemy = true, cfg = "skill" }, 
		},
		{ format = "x {3:output:LightningEffMult}",
			{ breakdown = "LightningEffMult" },
{ label = "玩家加成", modName = { "LightningPenetration", "ElementalPenetration" }, cfg = "skill" },
{ label = "敌人加成", modName = lightningHitTaken, enemy = true, cfg = "skill" },
		},
		{ format = "x {3:output:ColdEffMult}",
			{ breakdown = "ColdEffMult" },
{ label = "玩家加成", modName = { "ColdPenetration", "ElementalPenetration" }, cfg = "skill" },
{ label = "敌人加成", modName = coldHitTaken, enemy = true, cfg = "skill" },
		},
		{ format = "x {3:output:FireEffMult}",
			{ breakdown = "FireEffMult" },
{ label = "玩家加成", modName = { "FirePenetration", "ElementalPenetration" }, cfg = "skill" },
{ label = "敌人加成", modName = fireHitTaken, enemy = true, cfg = "skill" },
		},
		{ format = "x {3:output:ChaosEffMult}",
			{ breakdown = "ChaosEffMult" },
{ label = "敌人加成", modName = "ChaosPenetration", cfg = "skill" },
{ label = "敌人加成", modName = chaosHitTaken, enemy = true, cfg = "skill" },
		},
	},
{ label = "技能击中伤害", textSize = 12, notFlag = "attack",
		{ format = "{0:output:TotalMin} to {0:output:TotalMax}", },
		{ format = "{0:output:PhysicalMin} to {0:output:PhysicalMax}", 
			{ breakdown = "Physical" }, 
{ label = "转换", modType = "BASE", cfg = "skill", modName = physicalConvert }, 
		},
		{ format = "{0:output:LightningMin} to {0:output:LightningMax}", 
			{ breakdown = "Lightning" }, 
{ label = "转换", modType = "BASE", cfg = "skill", modName = lightningConvert }, 
		},
		{ format = "{0:output:ColdMin} to {0:output:ColdMax}", 
			{ breakdown = "Cold" }, 
{ label = "转换", modType = "BASE", cfg = "skill", modName = coldConvert }, 
		},
		{ format = "{0:output:FireMin} to {0:output:FireMax}", 
			{ breakdown = "Fire" }, 
{ label = "转换", modType = "BASE", cfg = "skill", modName = fireConvert }, 
		},
		{ format = "{0:output:ChaosMin} to {0:output:ChaosMax}", 
			{ breakdown = "Chaos" }, 
		},
	},
{ label = "技能平均击中伤害", notFlag = "attack", { format = "{1:output:AverageHit}", { breakdown = "AverageHit" }, }, },
	-- Main Hand Hit Damage
{ label = "主手总【提高】", bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack",
		{ format = "{0:mod:1}%", { modName = "Damage", modType = "INC", cfg = "weapon1" }, },
		{ format = "{0:mod:1}%", { modName = "PhysicalDamage", modType = "INC", cfg = "weapon1" }, },
		{ format = "{0:mod:1}%", { modName = { "LightningDamage", "ElementalDamage" }, modType = "INC", cfg = "weapon1" }, },
		{ format = "{0:mod:1}%", { modName = { "ColdDamage", "ElementalDamage" }, modType = "INC", cfg = "weapon1" }, },
		{ format = "{0:mod:1}%", { modName = { "FireDamage", "ElementalDamage" }, modType = "INC", cfg = "weapon1" }, },
		{ format = "{0:mod:1}%", { modName = "ChaosDamage", modType = "INC", cfg = "weapon1" }, },
	},
{ label = "主手总【额外提高】", bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack",
		{ format = "{0:mod:1}%", { modName = "Damage", modType = "MORE", cfg = "weapon1" }, },
		{ format = "{0:mod:1}%", { modName = "PhysicalDamage", modType = "MORE", cfg = "weapon1" }, },
		{ format = "{0:mod:1}%", { modName = { "LightningDamage", "ElementalDamage" }, modType = "MORE", cfg = "weapon1" }, },
		{ format = "{0:mod:1}%", { modName = { "ColdDamage", "ElementalDamage" }, modType = "MORE", cfg = "weapon1" }, },
		{ format = "{0:mod:1}%", { modName = { "FireDamage", "ElementalDamage" }, modType = "MORE", cfg = "weapon1" }, },
		{ format = "{0:mod:1}%", { modName = "ChaosDamage", modType = "MORE", cfg = "weapon1" }, },
	},
{ label = "主手有效 DPS Mod", bgCol = colorCodes.MAINHANDBG, flagList = {"weapon1Attack","effective"},
		{ },
		{ format = "x {3:output:MainHand.PhysicalEffMult}",
			{ breakdown = "MainHand.PhysicalEffMult" },
{ label = "敌人加成", modName = physicalHitTaken, enemy = true, cfg = "weapon1" }, 
		},
		{ format = "x {3:output:MainHand.LightningEffMult}",
			{ breakdown = "MainHand.LightningEffMult" },
{ label = "敌人加成", modName = { "LightningPenetration", "ElementalPenetration" }, cfg = "weapon1" },
{ label = "敌人加成", modName = lightningHitTaken, enemy = true, cfg = "weapon1" },
		},
		{ format = "x {3:output:MainHand.ColdEffMult}",
			{ breakdown = "MainHand.ColdEffMult" },
{ label = "敌人加成", modName = { "ColdPenetration", "ElementalPenetration" }, cfg = "weapon1" },
{ label = "敌人加成", modName = coldHitTaken, enemy = true, cfg = "weapon1" },
		},
		{ format = "x {3:output:MainHand.FireEffMult}",
			{ breakdown = "MainHand.FireEffMult" },
{ label = "敌人加成", modName = { "FirePenetration", "ElementalPenetration" }, cfg = "weapon1" },
{ label = "敌人加成", modName = fireHitTaken, enemy = true, cfg = "weapon1" },
		},
		{ format = "x {3:output:MainHand.ChaosEffMult}",
			{ breakdown = "MainHand.ChaosEffMult" },
{ label = "敌人加成", modName = "ChaosPenetration", cfg = "weapon1" },
{ label = "敌人加成", modName = chaosHitTaken, enemy = true, cfg = "weapon1" },
		},
	},
{ label = "主手击中伤害", bgCol = colorCodes.MAINHANDBG, textSize = 12, flag = "weapon1Attack",
		{ format = "{0:output:MainHand.TotalMin} to {0:output:MainHand.TotalMax}", },
		{ format = "{0:output:MainHand.PhysicalMin} to {0:output:MainHand.PhysicalMax}", 
			{ breakdown = "MainHand.Physical" }, 
{ label = "转换", modType = "BASE", cfg = "weapon1", modName = physicalConvert },
		},
		{ format = "{0:output:MainHand.LightningMin} to {0:output:MainHand.LightningMax}", 
			{ breakdown = "MainHand.Lightning" }, 
{ label = "转换", modType = "BASE", cfg = "weapon1", modName = lightningConvert }, 
		},
		{ format = "{0:output:MainHand.ColdMin} to {0:output:MainHand.ColdMax}", 
			{ breakdown = "MainHand.Cold" }, 
{ label = "转换", modType = "BASE", cfg = "weapon1", modName = coldConvert }, 
		},
		{ format = "{0:output:MainHand.FireMin} to {0:output:MainHand.FireMax}", 
			{ breakdown = "MainHand.Fire" }, 
{ label = "转换", modType = "BASE", cfg = "weapon1", modName = fireConvert },
		},
		{ format = "{0:output:MainHand.ChaosMin} to {0:output:MainHand.ChaosMax}", 
			{ breakdown = "MainHand.Chaos" }, 
		},
	},
{ label = "主手平均击中伤害", bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack", { format = "{1:output:MainHand.AverageHit}", { breakdown = "MainHand.AverageHit" }, }, },
	-- Off Hand Hit Damage
{ label = "副手总【提高】", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack",
		{ format = "{0:mod:1}%", { modName = "Damage", modType = "INC", cfg = "weapon2" }, },
		{ format = "{0:mod:1}%", { modName = "PhysicalDamage", modType = "INC", cfg = "weapon2" }, },
		{ format = "{0:mod:1}%", { modName = { "LightningDamage", "ElementalDamage" }, modType = "INC", cfg = "weapon2" }, },
		{ format = "{0:mod:1}%", { modName = { "ColdDamage", "ElementalDamage" }, modType = "INC", cfg = "weapon2" }, },
		{ format = "{0:mod:1}%", { modName = { "FireDamage", "ElementalDamage" }, modType = "INC", cfg = "weapon2" }, },
		{ format = "{0:mod:1}%", { modName = "ChaosDamage", modType = "INC", cfg = "weapon2" }, },
	},
{ label = "副手总【额外提高】", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack",
		{ format = "{0:mod:1}%", { modName = "Damage", modType = "MORE", cfg = "weapon2" }, },
		{ format = "{0:mod:1}%", { modName = "PhysicalDamage", modType = "MORE", cfg = "weapon2" }, },
		{ format = "{0:mod:1}%", { modName = { "LightningDamage", "ElementalDamage" }, modType = "MORE", cfg = "weapon2" }, },
		{ format = "{0:mod:1}%", { modName = { "ColdDamage", "ElementalDamage" }, modType = "MORE", cfg = "weapon2" }, },
		{ format = "{0:mod:1}%", { modName = { "FireDamage", "ElementalDamage" }, modType = "MORE", cfg = "weapon2" }, },
		{ format = "{0:mod:1}%", { modName = "ChaosDamage", modType = "MORE", cfg = "weapon2" }, },
	},
{ label = "副手有效 DPS Mod", bgCol = colorCodes.OFFHANDBG, flagList = {"weapon2Attack","effective"},
		{ },
		{ format = "x {3:output:OffHand.PhysicalEffMult}",
			{ breakdown = "OffHand.PhysicalEffMult" },
{ label = "敌人加成", modName = physicalHitTaken, enemy = true, cfg = "weapon2" }, 
		},
		{ format = "x {3:output:OffHand.LightningEffMult}",
			{ breakdown = "OffHand.LightningEffMult" },
{ label = "玩家加成", modName = { "LightningPenetration", "ElementalPenetration" }, cfg = "weapon2" },
{ label = "敌人加成", modName = lightningHitTaken, enemy = true, cfg = "weapon2" },
		},
		{ format = "x {3:output:OffHand.ColdEffMult}",
			{ breakdown = "OffHand.ColdEffMult" },
{ label = "玩家加成", modName = { "ColdPenetration", "ElementalPenetration" }, cfg = "weapon2" },
{ label = "敌人加成", modName = coldHitTaken, enemy = true, cfg = "weapon2" },
		},
		{ format = "x {3:output:OffHand.FireEffMult}",
			{ breakdown = "OffHand.FireEffMult" },
{ label = "玩家加成", modName = { "FirePenetration", "ElementalPenetration" }, cfg = "weapon2" },
{ label = "敌人加成", modName = fireHitTaken, enemy = true, cfg = "weapon2" },
		},
		{ format = "x {3:output:OffHand.ChaosEffMult}",
			{ breakdown = "OffHand.ChaosEffMult" },
{ label = "敌人加成", modName = "ChaosPenetration", cfg = "weapon2" },
{ label = "敌人加成", modName = chaosHitTaken, enemy = true, cfg = "weapon2" },
		},
	},
{ label = "副手击中伤害", bgCol = colorCodes.OFFHANDBG, textSize = 12, flag = "weapon2Attack",
		{ format = "{0:output:OffHand.TotalMin} to {0:output:OffHand.TotalMax}", },
		{ format = "{0:output:OffHand.PhysicalMin} to {0:output:OffHand.PhysicalMax}", 
			{ breakdown = "OffHand.Physical" }, 
{ label = "转换", modType = "BASE", cfg = "weapon2", modName = physicalConvert },
		},
		{ format = "{0:output:OffHand.LightningMin} to {0:output:OffHand.LightningMax}", 
			{ breakdown = "OffHand.Lightning" }, 
{ label = "转换", modType = "BASE", cfg = "weapon2", modName = lightningConvert }, 
		},
		{ format = "{0:output:OffHand.ColdMin} to {0:output:OffHand.ColdMax}", 
			{ breakdown = "OffHand.Cold" }, 
{ label = "转换", modType = "BASE", cfg = "weapon2", modName = coldConvert }, 
		},
		{ format = "{0:output:OffHand.FireMin} to {0:output:OffHand.FireMax}", 
			{ breakdown = "OffHand.Fire" }, 
{ label = "转换", modType = "BASE", cfg = "weapon2", modName = fireConvert }, 
		},
		{ format = "{0:output:OffHand.ChaosMin} to {0:output:OffHand.ChaosMax}", 
			{ breakdown = "OffHand.Chaos" },
		},
	},
{ label = "副手平均击中伤害", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack", { format = "{1:output:OffHand.AverageHit}", { breakdown = "OffHand.AverageHit" }, }, },
{ label = "平均伤害", flag = "attack", { format = "{1:output:AverageDamage}", 
		{ breakdown = "MainHand.AverageDamage" },
		{ breakdown = "OffHand.AverageDamage" },
		{ breakdown = "AverageDamage" },
	}, },
{ label = "技能 DPS", flag = "notAverage", { format = "{1:output:TotalDPS}", { breakdown = "TotalDPS" }, }, },
{ label = "魔力消耗", { format = "{0:output:ManaCost}", { breakdown = "ManaCost" }, { modName = "ManaCost", cfg = "skill" }, }, },
} },
{ 3, "Dot", 1, "技能持续伤害", colorCodes.OFFENCE, {
	extra = "{1:output:TotalDot} total DoT",
	flag = "dot",
	colWidth = 95,
{ { format = "所有:", }, { format = "物理:" }, { format = "闪电:" }, { format = "冰霜:" }, { format = "火焰:" }, { format = "混沌:" }, },
{ label = "所有的【提高】",
		{ format = "{0:mod:1}%", { modName = "Damage", modType = "INC", cfg = "dot" }, },
		{ format = "{0:mod:1}%", { modName = "PhysicalDamage", modType = "INC", cfg = "dotPhysical" }, },
		{ format = "{0:mod:1}%", { modName = { "LightningDamage", "ElementalDamage" }, modType = "INC", cfg = "dotLightning" }, },
		{ format = "{0:mod:1}%", { modName = { "ColdDamage", "ElementalDamage" }, modType = "INC", cfg = "dotCold" }, },
		{ format = "{0:mod:1}%", { modName = { "FireDamage", "ElementalDamage" }, modType = "INC", cfg = "dotFire" }, },
		{ format = "{0:mod:1}%", { modName = "ChaosDamage", modType = "INC", cfg = "dotChaos" }, },
	},
{ label = "所有的【额外提高】",
		{ format = "{0:mod:1}%", { modName = "Damage", modType = "MORE", cfg = "dot" }, },
		{ format = "{0:mod:1}%", { modName = "PhysicalDamage", modType = "MORE", cfg = "dotPhysical" }, },
		{ format = "{0:mod:1}%", { modName = { "LightningDamage", "ElementalDamage" }, modType = "MORE", cfg = "dotLightning" }, },
		{ format = "{0:mod:1}%", { modName = { "ColdDamage", "ElementalDamage" }, modType = "MORE", cfg = "dotCold" }, },
		{ format = "{0:mod:1}%", { modName = { "FireDamage", "ElementalDamage" }, modType = "MORE", cfg = "dotFire" }, },
		{ format = "{0:mod:1}%", { modName = "ChaosDamage", modType = "MORE", cfg = "dotChaos" }, },
	},
{ label = "有效 DPS Mod", flag = "effective",
		{ },
		{ format = "x {3:output:PhysicalDotEffMult}",
			{ breakdown = "PhysicalDotEffMult" },
{ label = "敌人加成", modName = { "DamageTaken", "DamageTakenOverTime", "PhysicalDamageTaken", "PhysicalDamageTakenOverTime", "PhysicalDamageReduction" }, enemy = true }, 
		},
		{ format = "x {3:output:LightningDotEffMult}",
			{ breakdown = "LightningDotEffMult" },
{ label = "敌人加成", modName = { "DamageTaken", "DamageTakenOverTime", "LightningDamageTaken", "LightningDamageTakenOverTime", "ElementalDamageTaken", "LightningResist", "ElementalResist" }, enemy = true },
		},
		{ format = "x {3:output:ColdDotEffMult}",
			{ breakdown = "ColdDotEffMult" },
{ label = "敌人加成", modName = { "DamageTaken", "DamageTakenOverTime", "ColdDamageTaken", "ColdDamageTakenOverTime", "ElementalDamageTaken", "ColdResist", "ElementalResist" }, enemy = true },
		},
		{ format = "x {3:output:FireDotEffMult}",
			{ breakdown = "FireDotEffMult" },
{ label = "敌人加成", modName = { "DamageTaken", "DamageTakenOverTime", "FireDamageTaken", "FireDamageTakenOverTime", "ElementalDamageTaken", "FireResist", "ElementalResist" }, enemy = true },
		},
		{ format = "x {3:output:ChaosDotEffMult}",
			{ breakdown = "ChaosDotEffMult" },
{ label = "敌人加成", modName = { "DamageTaken", "DamageTakenOverTime", "ChaosDamageTaken", "ChaosDamageTakenOverTime", "ChaosResist" }, enemy = true },
		},
	},
{ label = "持续伤害",
		{ format = "{1:output:TotalDot}", },
		{ format = "{1:output:PhysicalDot}", { breakdown = "PhysicalDot" }, },
		{ format = "{1:output:LightningDot}", { breakdown = "LightningDot" }, },
		{ format = "{1:output:ColdDot}", { breakdown = "ColdDot" }, },
		{ format = "{1:output:FireDot}", { breakdown = "FireDot" }, },
		{ format = "{1:output:ChaosDot}", { breakdown = "ChaosDot" }, },
	},
{ label = "魔力消耗", { format = "{0:output:ManaCost}", { breakdown = "ManaCost" }, { modName = "ManaCost", cfg = "skill" }, }, },
} },
{ 1, "Speed", 1, "攻击/施法速度", colorCodes.OFFENCE, {
	extra = "{2:output:Speed}/s",
{ label = "主手总【提高】攻速", bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack", { format = "{0:mod:1}%", { modName = "Speed", modType = "INC", cfg = "weapon1", }, }, },
{ label = "主手总【额外提高】攻速", bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack", { format = "{0:mod:1}%", { modName = "Speed", modType = "MORE", cfg = "weapon1", }, }, },
{ label = "主手每秒攻击", bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack", { format = "{2:output:MainHand.Speed}", { breakdown = "MainHand.Speed" }, }, },
{ label = "副手总【提高】攻速", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack", { format = "{0:mod:1}%", { modName = "Speed", modType = "INC", cfg = "weapon2", }, }, },
{ label = "副手总【额外提高】攻速", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack", { format = "{0:mod:1}%", { modName = "Speed", modType = "MORE", cfg = "weapon2", }, }, },
{ label = "副手每秒攻击次数", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack", { format = "{2:output:OffHand.Speed}", { breakdown = "OffHand.Speed" }, }, },
{ label = "每秒攻击", flag = "bothWeaponAttack", { format = "{2:output:Speed}", { breakdown = "Speed" }, }, },
{ label = "攻击时间", flag = "attack", { format = "{2:output:Time}s", }, },
{ label = "总【提高】施法速度", flag = "spell", { format = "{0:mod:1}%", { modName = "Speed", modType = "INC", cfg = "skill", }, }, },
{ label = "总【额外提高】施法速度", flag = "spell", { format = "{0:mod:1}%", { modName = "Speed", modType = "MORE", cfg = "skill", }, }, },
{ label = "每秒施法", flag = "spell", { format = "{2:output:Speed}", { breakdown = "Speed" }, }, },
{ label = "施法时间", flag = "spell", { format = "{2:output:Time}s", }, },
} },
{ 1, "Crit", 1, "暴击", colorCodes.OFFENCE, {
	extra = "{2:output:CritChance}% x{2:output:CritMultiplier}",
	flag = "hit",
	-- Skill

{ label = "提高暴击几率", notFlag = "attack", { format = "{0:mod:1,2}%", 
		{ label = "Player modifiers", modName = "CritChance", modType = "INC", cfg = "skill" }, 
		{ label = "Enemy modifiers", modName = "SelfCritChance", modType = "INC", enemy = true }, 
	}, },


{ label = "暴击几率", notFlag = "attack", { format = "{2:output:CritChance}%", 
		{ breakdown = "CritChance" }, 
{ label = "玩家加成", modName = "CritChance", cfg = "skill" }, 
{ label = "敌人加成", modName = "SelfCritChance", enemy = true }, 
	}, },
{ label = "暴击伤害", notFlag = "attack", { format = "x {2:output:CritMultiplier}", 
		{ breakdown = "CritMultiplier" }, 
{ label = "玩家加成", modName = "CritMultiplier", cfg = "skill" }, 
{ label = "敌人加成", modName = "SelfCritMultiplier", enemy = true },
	}, },
{ label = "暴击效果 Mod", notFlag = "attack", { format = "x {3:output:CritEffect}", { breakdown = "CritEffect" }, }, },
	-- Main Hand

{ label = "主手暴击几率提高", bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack", { format = "{0:mod:1,2}%", 
		{ label = "Player modifiers", modName = "CritChance", modType = "INC", cfg = "weapon1" }, 
		{ label = "Enemy modifiers", modName = "SelfCritChance", modType = "INC", enemy = true }, 
	}, },

{ label = "主手暴击几率", bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack", { format = "{2:output:MainHand.CritChance}%", 
		{ breakdown = "MainHand.CritChance" }, 
{ label = "玩家加成", modName = "CritChance", cfg = "weapon1" }, 
{ label = "敌人加成", modName = "SelfCritChance", enemy = true }, 
	}, },
{ label = "主手暴击伤害", bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack", { format = "x {2:output:MainHand.CritMultiplier}", 
		{ breakdown = "MainHand.CritMultiplier" }, 
{ label = "玩家加成", modName = "CritMultiplier", cfg = "weapon1" }, 
{ label = "敌人加成", modName = "SelfCritMultiplier", enemy = true },
	}, },

{ label = "主手暴击效果 Mod", bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack", { format = "x {3:output:MainHand.CritEffect}", { breakdown = "MainHand.CritEffect" }, }, },
	-- Off Hand

{ label = "副手暴击几率提高", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack", { format = "{0:mod:1,2}%", 
		{ label = "Player modifiers", modName = "CritChance", modType = "INC", cfg = "weapon2" }, 
		{ label = "Enemy modifiers", modName = "SelfCritChance", modType = "INC", enemy = true }, 
	}, },

{ label = "副手暴击几率", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack", { format = "{2:output:OffHand.CritChance}%", 
		{ breakdown = "OffHand.CritChance" }, 
{ label = "玩家加成", modName = "CritChance", cfg = "weapon2" },
{ label = "敌人加成", modName = "SelfCritChance", enemy = true }, 
	}, },
{ label = "副手暴击伤害", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack", { format = "x {2:output:OffHand.CritMultiplier}", 
		{ breakdown = "OffHand.CritMultiplier" }, 
{ label = "玩家加成", modName = "CritMultiplier", cfg = "weapon2" }, 
{ label = "敌人加成", modName = "SelfCritMultiplier", enemy = true },
	}, },

{ label = "副手暴击效果 Mod", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack", { format = "x {3:output:OffHand.CritEffect}", { breakdown = "OffHand.CritEffect" }, }, },
} },
{ 1, "HitChance", 1, "命中", colorCodes.OFFENCE, {
	extra = "{0:output:HitChance}%",
	flag = "attack",
{ label = "主手命中", bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack", { format = "{0:output:MainHand.Accuracy}", 
		{ breakdown = "MainHand.Accuracy" }, 
		{ modName = "Accuracy", cfg = "weapon1" }, 
	}, },
{ label = "主手击中几率", bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack", { format = "{0:output:MainHand.HitChance}%",
		{ breakdown = "MainHand.HitChance" }, 
{ label = "敌人闪避加成", modName = "Evasion", enemy = true },
	}, },
{ label = "副手命中", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack", { format = "{0:output:OffHand.Accuracy}",
		{ breakdown = "OffHand.Accuracy" }, 
		{ modName = "Accuracy", cfg = "weapon2" },
	}, },
{ label = "副手击中几率", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack", { format = "{0:output:OffHand.HitChance}%",
		{ breakdown = "OffHand.HitChance" },
{ label = "敌人闪避加成", modName = "Evasion", enemy = true },
	}, },
} },
{ 1, "SkillTypeStats", 1, "技能类型-特殊状态", colorCodes.OFFENCE, {
{ label = "召唤生物最大数量", haveOutput = "ActiveMinionLimit", { format = "{0:output:ActiveMinionLimit}",
{ breakdown = "ActiveMinionLimit" }, 

{ modName = { "ActiveSpectreLimit"}, flag="spectre",cfg = "skill" }, 
{ modName = { "ActiveGolemLimit"}, flag="golem",cfg = "skill" }, 

}, },
{ label = "技能CD", haveOutput = "Cooldown", { format = "{2:output:Cooldown}s", 
		{ breakdown = "Cooldown" }, 
		{ modName = "CooldownRecovery", cfg = "skill" },
	}, },
{ label = "持续时间词缀", flag = "duration", { format = "x {2:output:DurationMod}", 
		{ breakdown = "DurationMod"}, 
		{ modName = { "Duration", "SkillAndDamagingAilmentDuration" }, cfg = "skill" }, 
	}, },
{ label = "技能持续时间", flag = "duration", haveOutput = "Duration", { format = "{2:output:Duration}s", { breakdown = "Duration" }, }, },
{ label = "次要持续时间", flag = "duration", haveOutput = "DurationSecondary", { format = "{2:output:DurationSecondary}s", { breakdown = "DurationSecondary" }, }, },

{ label = "光环持续时间", haveOutput = "AuraDuration", { format = "{2:output:AuraDuration}s", { breakdown = "AuraDuration" }, }, },
{ label = "魔力保留持续时间", haveOutput = "ReserveDuration", { format = "{2:output:ReserveDuration}s", { breakdown = "ReserveDuration" }, }, },

{ label = "最大连锁数", flag = "chaining", { format = "{output:ChainMaxString}", { modName = { "CannotChain", "ChainCountMax" }, cfg = "skill" }, }, }, 
{ label = "投射物数量", flag = "projectile", { format = "{0:output:ProjectileCount}", { modName = "ProjectileCount", cfg = "skill" }, }, },
{ label = "穿透数量", flag = "projectile", { format = "{output:PierceCountString}", { modName = { "CannotPierce", "PierceCount", "PierceAllTargets" }, cfg = "skill" }, }, },
{ label = "投射物速度加成", flag = "projectile", { format = "x {2:output:ProjectileSpeedMod}",
		{ breakdown = "ProjectileSpeedMod" },
		{ modName = "ProjectileSpeed", cfg = "skill" },
	}, },
{ label = "范围效果加成",  haveOutput = "AreaOfEffectMod", { format = "x {2:output:AreaOfEffectMod}", 
		{ breakdown = "AreaOfEffectMod" }, 
		{ modName = "AreaOfEffect", cfg = "skill" },
	}, },
{ label = "半径", haveOutput = "AreaOfEffectRadius", { format = "{0:output:AreaOfEffectRadius}", { breakdown = "AreaOfEffectRadius" }, }, },
{ label = "次要半径", haveOutput = "AreaOfEffectRadiusSecondary", { format = "{0:output:AreaOfEffectRadiusSecondary}", { breakdown = "AreaOfEffectRadiusSecondary" }, }, },

{ label = "第三半径", haveOutput = "AreaOfEffectRadiusTertiary", { format = "{0:output:AreaOfEffectRadiusTertiary}", { breakdown = "AreaOfEffectRadiusTertiary" }, }, },

{ label = "武器范围", haveOutput = "WeaponRange", { format = "{0:output:WeaponRange}", { breakdown = "WeaponRange" }, }, },
{ label = "陷阱投掷时间", flag = "trap", { format = "{2:output:TrapThrowingTime}s", 
		{ breakdown = "TrapThrowingTime" },
		{ modName = "TrapThrowingSpeed", cfg = "skill" }, 
	}, },
{ label = "最大陷阱数量", flag = "trap", { format = "{0:output:ActiveTrapLimit}", { modName = "ActiveTrapLimit", cfg = "skill" }, }, },
{ label = "陷阱CD", haveOutput = "TrapCooldown", { format = "{2:output:TrapCooldown}s", 
		{ breakdown = "TrapCooldown" }, 
		{ modName = "CooldownRecovery", cfg = "skill" },
	}, },
{ label = "陷阱触发范围", flag = "trap", { format = "{0:output:TrapTriggerRadius}", 
		{ breakdown = "TrapTriggerRadius" },
{ label = "范围效果加成", modName = "TrapTriggerAreaOfEffect", cfg = "skill" },
	}, },
{ label = "地雷放置时间", flag = "mine", { format = "{2:output:MineLayingTime}s", 
		{ breakdown = "MineLayingTime" },
		{ modName = "MineLayingSpeed", cfg = "skill" }, 
	}, },
{ label = "最大地雷数量", flag = "mine", { format = "{0:output:ActiveMineLimit}", { modName = "ActiveMineLimit", cfg = "skill" }, }, },
{ label = "地雷引爆范围", flag = "mine", { format = "{0:output:MineDetonationRadius}", 
		{ breakdown = "MineDetonationRadius" },
{ label = "范围效果加成", modName = "MineDetonationAreaOfEffect", cfg = "skill" },
	}, },
{ label = "地雷光环范围", haveOutput = "MineAuraRadius", { format = "{0:output:MineAuraRadius}", { breakdown = "MineAuraRadius" }, }, },
{ label = "图腾放置时间", flag = "totem", { format = "{2:output:TotemPlacementTime}s", 
		{ breakdown = "TotemPlacementTime" },
		{ modName = "TotemPlacementSpeed", cfg = "skill" }, 
	}, },
{ label = "最大图腾数量", flag = "totem", { format = "{0:output:ActiveTotemLimit}", { modName = "ActiveTotemLimit", cfg = "skill" }, }, },
{ label = "图腾生命加成", flag = "totem", { format = "x {2:output:TotemLifeMod}", 
		{ breakdown = "TotemLifeMod" },
		{ modName = "TotemLife", cfg = "skill" },
	}, },
{ label = "图腾生命", flag = "totem", { format = "{0:output:TotemLife}", { breakdown = "TotemLife" }, }, },
} },
{ 1, "Bleed", 1, "流血", colorCodes.OFFENCE, {
	extra = "{0:output:BleedChance}% {1:output:BleedDPS} {2:output:BleedDuration}s",
	flag = "bleed",
{ label = "流血几率", { format = "{0:output:BleedChance}%", 
		{ breakdown = "MainHand.BleedChance" },
		{ breakdown = "OffHand.BleedChance" },
		{ breakdown = "BleedChance" },
{ label = "主手", flag = "weapon1Attack", modName = "BleedChance", modType = "BASE", cfg = "weapon1" },
{ label = "副手", flag = "weapon2Attack", modName = "BleedChance", modType = "BASE", cfg = "weapon2" },
	}, },
{ label = "总【提高】", { format = "{0:mod:1}%", { modName = { "Damage", "PhysicalDamage" }, modType = "INC", cfg = "bleed" }, }, },
{ label = "总【额外提高】", { format = "{0:mod:1}%", { modName = { "Damage", "PhysicalDamage" }, modType = "MORE", cfg = "bleed" }, }, },
{ label = "主手源物理伤害", bgCol = colorCodes.MAINHANDBG, textSize = 12, flag = "weapon1Attack", { format = "{0:output:MainHand.BleedPhysicalMin} to {0:output:MainHand.BleedPhysicalMax}", { breakdown = "MainHand.BleedPhysical" }, }, },
{ label = "副手源物理伤害", bgCol = colorCodes.OFFHANDBG, textSize = 12, flag = "weapon2Attack", { format = "{0:output:OffHand.BleedPhysicalMin} to {0:output:OffHand.BleedPhysicalMax}", { breakdown = "OffHand.BleedPhysical" }, }, },
{ label = "有效 DPS 加成", flag = "effective", { format = "x {3:output:BleedEffMult}", { breakdown = "BleedEffMult" }, { label = "敌人加成", modName = { "DamageTaken", "DamageTakenOverTime", "PhysicalDamageTaken", "PhysicalDamageTakenOverTime", "PhysicalDamageReduction" }, enemy = true }, }, },
{ label = "流血 DPS", { format = "{1:output:BleedDPS}", { breakdown = "BleedDPS" }, { breakdown = "MainHand.BleedDPS" }, { breakdown = "OffHand.BleedDPS" }, }, },
{ label = "流血持续时间", { format = "{2:output:BleedDuration}s", 
		{ breakdown = "BleedDuration" }, 
{ label = "玩家加成", modName = { "EnemyBleedDuration", "SkillAndDamagingAilmentDuration" }, cfg = "bleed" }, 
{ label = "敌人加成", modName = "SelfBleedDuration", enemy = true },
	}, },
} },
{ 1, "Impale", 1, "穿刺", colorCodes.OFFENCE, {
    flag = "impale",
	extra = "{0:output:ImpaleChance}%",
{ label = "穿刺效果持续次数", { format = "{0:output:ImpaleStacksMax}", }},
{ label = "穿刺层数", { format = "{0:output:ImpaleStacks}" }},
{ label = "主手穿刺几率", bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack", haveOutput = "MainHand.ImpaleChance", { format = "{0:output:MainHand.ImpaleChance}%",
		{ flag = "weapon1Attack", modName = "ImpaleChance", modType = "BASE", cfg = "weapon1" },
	}, },
{ label = "主手存储伤害",  bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack", haveOutput = "MainHand.ImpaleStoredDamage", { format = "{1:output:MainHand.ImpaleStoredDamage}%",
		{ breakdown = "MainHand.ImpaleStoredDamage" },
		{ flag = "weapon1Attack", modName = "ImpaleEffect", cfg = "weapon1" },
	}, },
{ label = "主手伤害加成.",  bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack", haveOutput = "MainHand.ImpaleModifier", { format = "{3:output:MainHand.ImpaleModifier}",
		{ breakdown = "MainHand.ImpaleModifier" },
	} },
{ label = "副手穿透几率", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack", haveOutput = "OffHand.ImpaleChance", { format = "{0:output:OffHand.ImpaleChance}%",
		{ flag = "weapon2Attack", modName = "ImpaleChance", modType = "BASE", cfg = "weapon2" },
	}, },
{ label = "副手存储伤害",  bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack", haveOutput = "OffHand.ImpaleStoredDamage", { format = "{1:output:OffHand.ImpaleStoredDamage}%",
		{ breakdown = "OffHand.ImpaleStoredDamage" },
		{ flag = "weapon2Attack", modName = "ImpaleEffect", cfg = "weapon2" },
	}, },
{ label = "副手伤害加成.", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack", haveOutput = "OffHand.ImpaleModifier", { format = "{3:output:OffHand.ImpaleModifier}", modType = "MORE",
		{ breakdown = "OffHand.ImpaleModifier" },
	}, },
} },

{ 1, "Poison", 1, "中毒", colorCodes.OFFENCE, {
	extra = "{0:output:PoisonChance}% {1:output:PoisonDPS} {2:output:PoisonDuration}s",
	flag = "poison",
{ label = "中毒几率", { format = "{0:output:PoisonChance}%", 
		{ breakdown = "MainHand.PoisonChance" }, 
		{ breakdown = "OffHand.PoisonChance" }, 
		{ breakdown = "PoisonChance" }, 
		{ notFlag = "attack", modName = "PoisonChance", modType = "BASE", cfg = "skill" }, 
{ label = "主手", flag = "weapon1Attack", modName = "PoisonChance", modType = "BASE", cfg = "weapon1" },
{ label = "副手", flag = "weapon2Attack", modName = "PoisonChance", modType = "BASE", cfg = "weapon2" },
	}, },
{ label = "总【提高】", { format = "{0:mod:1}%", { modName = { "Damage", "ChaosDamage" }, modType = "INC", cfg = "poison" }, }, },
{ label = "总【额外提高】", { format = "{0:mod:1}%", { modName = { "Damage", "ChaosDamage" }, modType = "MORE", cfg = "poison" }, }, },
{ label = "源物理伤害", textSize = 12, notFlag = "attack", haveOutput = "PoisonPhysicalMax", { format = "{0:output:PoisonPhysicalMin} to {0:output:PoisonPhysicalMax}", { breakdown = "PoisonPhysical" }, }, },
{ label = "主手源物理伤害", bgCol = colorCodes.MAINHANDBG, textSize = 12, flag = "weapon1Attack", haveOutput = "MainHand.PoisonPhysicalMax", { format = "{0:output:MainHand.PoisonPhysicalMin} to {0:output:MainHand.PoisonPhysicalMax}", { breakdown = "MainHand.PoisonPhysical" }, }, },
{ label = "副手源物理伤害", bgCol = colorCodes.OFFHANDBG, textSize = 12, flag = "weapon2Attack", haveOutput = "OffHand.PoisonPhysicalMax", { format = "{0:output:OffHand.PoisonPhysicalMin} to {0:output:OffHand.PoisonPhysicalMax}", { breakdown = "OffHand.PoisonPhysical" }, }, },
{ label = "源闪电伤害", textSize = 12, notFlag = "attack", haveOutput = "PoisonLightningMax", { format = "{0:output:PoisonLightningMin} to {0:output:PoisonLightningMax}", { breakdown = "PoisonLightning" }, }, },
{ label = "主手源闪电伤害", bgCol = colorCodes.MAINHANDBG, textSize = 12, flag = "weapon1Attack", haveOutput = "MainHand.PoisonLightningMax", { format = "{0:output:MainHand.PoisonLightningMin} to {0:output:MainHand.PoisonLightningMax}", { breakdown = "MainHand.PoisonLightning" }, }, },
{ label = "副手源闪电伤害", bgCol = colorCodes.OFFHANDBG, textSize = 12, flag = "weapon2Attack", haveOutput = "OffHand.PoisonLightningMax", { format = "{0:output:OffHand.PoisonLightningMin} to {0:output:OffHand.PoisonLightningMax}", { breakdown = "OffHand.PoisonLightning" }, }, },
{ label = "源冰霜伤害", textSize = 12, notFlag = "attack", haveOutput = "PoisonColdMax", { format = "{0:output:PoisonColdMin} to {0:output:PoisonColdMax}", { breakdown = "PoisonCold" }, }, },
{ label = "主手源冰霜伤害", bgCol = colorCodes.MAINHANDBG, textSize = 12, flag = "weapon1Attack", haveOutput = "MainHand.PoisonColdMax", { format = "{0:output:MainHand.PoisonColdMin} to {0:output:MainHand.PoisonColdMax}", { breakdown = "MainHand.PoisonCold" }, }, },
{ label = "副手源冰霜伤害", bgCol = colorCodes.OFFHANDBG, textSize = 12, flag = "weapon2Attack", haveOutput = "OffHand.PoisonColdMax", { format = "{0:output:OffHand.PoisonColdMin} to {0:output:OffHand.PoisonColdMax}", { breakdown = "OffHand.PoisonCold" }, }, },
{ label = "源火焰伤害", textSize = 12, notFlag = "attack", haveOutput = "PoisonFireMax", { format = "{0:output:PoisonFireMin} to {0:output:PoisonFireMax}", { breakdown = "PoisonFire" }, }, },
{ label = "主手源火焰伤害", bgCol = colorCodes.MAINHANDBG, textSize = 12, flag = "weapon1Attack", haveOutput = "MainHand.PoisonFireMax", { format = "{0:output:MainHand.PoisonFireMin} to {0:output:MainHand.PoisonFireMax}", { breakdown = "MainHand.PoisonFire" }, }, },
	{ label = "副手源火焰伤害", bgCol = colorCodes.OFFHANDBG, textSize = 12, flag = "weapon2Attack", haveOutput = "OffHand.PoisonFireMax", { format = "{0:output:OffHand.PoisonFireMin} to {0:output:OffHand.PoisonFireMax}", { breakdown = "OffHand.PoisonFire" }, }, },
{ label = "源混沌伤害", textSize = 12, notFlag = "attack", haveOutput = "PoisonChaosMax", { format = "{0:output:PoisonChaosMin} to {0:output:PoisonChaosMax}", { breakdown = "PoisonChaos" }, }, },
{ label = "主手源混沌伤害", bgCol = colorCodes.MAINHANDBG, textSize = 12, flag = "weapon1Attack", haveOutput = "MainHand.PoisonChaosMax", { format = "{0:output:MainHand.PoisonChaosMin} to {0:output:MainHand.PoisonChaosMax}", { breakdown = "MainHand.PoisonChaos" }, }, },
{ label = "副手源混沌伤害", bgCol = colorCodes.OFFHANDBG, textSize = 12, flag = "weapon2Attack", haveOutput = "OffHand.PoisonChaosMax", { format = "{0:output:OffHand.PoisonChaosMin} to {0:output:OffHand.PoisonChaosMax}", { breakdown = "OffHand.PoisonChaos" }, }, },
{ label = "有效 DPS 加成", flag = "effective", { format = "x {3:output:PoisonEffMult}", 
		{ breakdown = "PoisonEffMult" }, 

		
{ label = "敌人加成", modName = { "ChaosResist", "DamageTaken", "DamageTakenOverTime", "ChaosDamageTaken", "ChaosDamageTakenOverTime" }, enemy = true },
	}, },
 
	
{ label = "中毒 DPS", { format = "{1:output:PoisonDPS}", 
		{ breakdown = "PoisonDPS" }, 
		{ breakdown = "MainHand.PoisonDPS" },
		{ breakdown = "OffHand.PoisonDPS" },
	}, },
{ label = "中毒持续时间", { format = "{2:output:PoisonDuration}s", 
		{ breakdown = "PoisonDuration" },
{ label = "玩家加成", modName = { "EnemyPoisonDuration", "SkillAndDamagingAilmentDuration" }, cfg = "poison" },
		{ label = "Enemy modifiers", modName = "SelfPoisonDuration", enemy = true },
	}, },
{ label = "每个中毒实例伤害", { format = "{1:output:PoisonDamage}", 
		{ breakdown = "MainHand.PoisonDamage" }, 
		{ breakdown = "OffHand.PoisonDamage" }, 
		{ breakdown = "PoisonDamage" }, 
	}, },
{ flag = "notAverage", label = "最大中毒层数", { format = "{1:output:TotalPoisonStacks}",
		{ breakdown = "MainHand.TotalPoisonStacks" }, 
		{ breakdown = "OffHand.TotalPoisonStacks" }, 
		{ breakdown = "TotalPoisonStacks" }, 
	}, },
} },
{ 1, "Ignite", 1, "点燃", colorCodes.OFFENCE, {	
	extra = "{0:output:IgniteChance}% {1:output:IgniteDPS} {2:output:IgniteDuration}s",
	flag = "ignite",
{ label = "点燃几率", { format = "{0:output:IgniteChance}%", 
		{ breakdown = "MainHand.IgniteChance" }, 
		{ breakdown = "OffHand.IgniteChance" },
		{ breakdown = "IgniteChance" },
{ label = "玩家加成", modName = "EnemyIgniteChance", cfg = "skill" },
{ label = "敌人加成", modName = "SelfIgniteChance", enemy = true },
	}, },
{ label = "总【提高】", { format = "{0:mod:1}%", { modName = { "Damage", "FireDamage", "ElementalDamage" }, modType = "INC", cfg = "ignite" }, }, },
{ label = "总【额外提高】", { format = "{0:mod:1}%", { modName = { "Damage", "FireDamage", "ElementalDamage" }, modType = "MORE", cfg = "ignite" }, }, },
{ label = "源物理伤害", textSize = 12, notFlag = "attack", haveOutput = "IgnitePhysicalMax", { format = "{0:output:IgnitePhysicalMin} to {0:output:IgnitePhysicalMax}", { breakdown = "IgnitePhysical" }, }, },
{ label = "主手源物理伤害", bgCol = colorCodes.MAINHANDBG, textSize = 12, flag = "weapon1Attack", haveOutput = "MainHand.IgnitePhysicalMax", { format = "{0:output:MainHand.IgnitePhysicalMin} to {0:output:MainHand.IgnitePhysicalMax}", { breakdown = "MainHand.IgnitePhysical" }, }, },
{ label = "副手源物理伤害", bgCol = colorCodes.OFFHANDBG, textSize = 12, flag = "weapon2Attack", haveOutput = "OffHand.IgnitePhysicalMax", { format = "{0:output:OffHand.IgnitePhysicalMin} to {0:output:OffHand.IgnitePhysicalMax}", { breakdown = "OffHand.IgnitePhysical" }, }, },
{ label = "源闪电伤害", textSize = 12, notFlag = "attack", haveOutput = "IgniteLightningMax", { format = "{0:output:IgniteLightningMin} to {0:output:IgniteLightningMax}", { breakdown = "IgniteLightning" }, }, },
{ label = "主手源闪电伤害", bgCol = colorCodes.MAINHANDBG, textSize = 12, flag = "weapon1Attack", haveOutput = "MainHand.IgniteLightningMax", { format = "{0:output:MainHand.IgniteLightningMin} to {0:output:MainHand.IgniteLightningMax}", { breakdown = "MainHand.IgniteLightning" }, }, },
{ label = "副手源闪电伤害", bgCol = colorCodes.OFFHANDBG, textSize = 12, flag = "weapon2Attack", haveOutput = "OffHand.IgniteLightningMax", { format = "{0:output:OffHand.IgniteLightningMin} to {0:output:OffHand.IgniteLightningMax}", { breakdown = "OffHand.IgniteLightning" }, }, },
{ label = "源冰霜伤害", textSize = 12, notFlag = "attack", haveOutput = "IgniteColdMax", { format = "{0:output:IgniteColdMin} to {0:output:IgniteColdMax}", { breakdown = "IgniteCold" }, }, },
{ label = "主手源冰霜伤害", bgCol = colorCodes.MAINHANDBG, textSize = 12, flag = "weapon1Attack", haveOutput = "MainHand.IgniteColdMax", { format = "{0:output:MainHand.IgniteColdMin} to {0:output:MainHand.IgniteColdMax}", { breakdown = "MainHand.IgniteCold" }, }, },
{ label = "副手源冰霜伤害", bgCol = colorCodes.OFFHANDBG, textSize = 12, flag = "weapon2Attack", haveOutput = "OffHand.IgniteColdMax", { format = "{0:output:OffHand.IgniteColdMin} to {0:output:OffHand.IgniteColdMax}", { breakdown = "OffHand.IgniteCold" }, }, },
{ label = "源火焰伤害", textSize = 12, notFlag = "attack", haveOutput = "IgniteFireMax", { format = "{0:output:IgniteFireMin} to {0:output:IgniteFireMax}", { breakdown = "IgniteFire" }, }, },
{ label = "主手源火焰伤害", bgCol = colorCodes.MAINHANDBG, textSize = 12, flag = "weapon1Attack", haveOutput = "MainHand.IgniteFireMax", { format = "{0:output:MainHand.IgniteFireMin} to {0:output:MainHand.IgniteFireMax}", { breakdown = "MainHand.IgniteFire" }, }, },
{ label = "副手源火焰伤害", bgCol = colorCodes.OFFHANDBG, textSize = 12, flag = "weapon2Attack", haveOutput = "OffHand.IgniteFireMax", { format = "{0:output:OffHand.IgniteFireMin} to {0:output:OffHand.IgniteFireMax}", { breakdown = "OffHand.IgniteFire" }, }, },
{ label = "源混沌伤害", textSize = 12, notFlag = "attack", haveOutput = "IgniteChaosMax", { format = "{0:output:IgniteChaosMin} to {0:output:IgniteChaosMax}", { breakdown = "IgniteChaos" }, }, },
{ label = "主手源混沌伤害", bgCol = colorCodes.MAINHANDBG, textSize = 12, flag = "weapon1Attack", haveOutput = "MainHand.IgniteChaosMax", { format = "{0:output:MainHand.IgniteChaosMin} to {0:output:MainHand.IgniteChaosMax}", { breakdown = "MainHand.IgniteChaos" }, }, },
{ label = "副手源混沌伤害", bgCol = colorCodes.OFFHANDBG, textSize = 12, flag = "weapon2Attack", haveOutput = "OffHand.IgniteChaosMax", { format = "{0:output:OffHand.IgniteChaosMin} to {0:output:OffHand.IgniteChaosMax}", { breakdown = "OffHand.IgniteChaos" }, }, },
{ label = "有效 DPS 加成", flag = "effective", { format = "x {3:output:IgniteEffMult}", 
		{ breakdown = "IgniteEffMult" }, 
{ label = "敌人加成", modName = { "FireResist", "ElementalResist", "DamageTaken", "DamageTakenOverTime", "FireDamageTaken", "FireDamageTakenOverTime", "ElementalDamageTaken" }, enemy = true },
	}, },
{ label = "点燃 DPS", { format = "{1:output:IgniteDPS}", 
		{ breakdown = "IgniteDPS" }, 
		{ breakdown = "MainHand.IgniteDPS" },
		{ breakdown = "OffHand.IgniteDPS" },
		{ modName = { "IgniteBurnRate" }, cfg = "skill" }, 
	}, },
{ label = "点燃持续时间", { format = "{2:output:IgniteDuration}s",
		{ breakdown = "IgniteDuration" },
{ label = "玩家加成", modName = { "EnemyIgniteDuration", "SkillAndDamagingAilmentDuration" }, cfg = "skill" },
{ label = "敌人加成", modName = "SelfIgniteDuration", enemy = true },
	}, },
{ label = "每个点燃实例伤害", flag = "igniteCanStack", { format = "{1:output:IgniteDamage}",
		{ breakdown = "MainHand.IgniteDamage" },
		{ breakdown = "OffHand.IgniteDamage" },
		{ breakdown = "IgniteDamage" },
	}, },
{ flagList = { "notAverage", "igniteCanStack" }, label = "最大点燃层数", { format = "{1:output:TotalIgniteStacks}",
		{ breakdown = "MainHand.TotalIgniteStacks" }, 
		{ breakdown = "OffHand.TotalIgniteStacks" }, 
		{ breakdown = "TotalIgniteStacks" }, 
	}, },
} },
{ 1, "Decay", 1, "腐化", colorCodes.OFFENCE, {
	extra = "{1:output:DecayDPS} {2:output:DecayDuration}s",
	flag = "decay",
{ label = "总【提高】", { format = "{0:mod:1}%", { modName = { "Damage", "ChaosDamage" }, modType = "INC", cfg = "decay" }, }, },
{ label = "总【额外提高】", { format = "{0:mod:1}%", { modName = { "Damage", "ChaosDamage" }, modType = "MORE", cfg = "decay" }, }, },
{ label = "有效 DPS 加成", flag = "effective", { format = "x {3:output:DecayEffMult}", 
		{ breakdown = "DecayEffMult" }, 
{ label = "敌人加成", modName = { "ChaosResist", "DamageTaken", "DamageTakenOverTime", "ChaosDamageTaken", "ChaosDamageTakenOverTime" }, enemy = true },
	}, },
{ label = "腐化 DPS", { format = "{1:output:DecayDPS}", 
		{ breakdown = "DecayDPS" }, 
	}, },
{ label = "腐化持续时间", { format = "{2:output:DecayDuration}s", 
		{ breakdown = "DecayDuration" },
		{ modName = { "Duration", "SkillAndDamagingAilmentDuration" }, cfg = "decay" },
	}, },
} },
{ 1, "LeechGain", 1, "偷取 & 击中回复", colorCodes.OFFENCE, {
{ label = "最大生命偷取", flag = "leechLife", { format = "{1:output:MaxLifeLeechRate}", 
		{ breakdown = "MaxLifeLeechRate" },
		{ modName = "MaxLifeLeechRate" },
	}, },
{ label = "生命偷取速率", flag = "leechLife", notFlag = "showAverage", { format = "{1:output:LifeLeechRate}", 
		{ breakdown = "LifeLeech" }, 
{ label = "玩家加成", notFlagList = { "totem", "attack" }, modName = { "DamageLeech", "DamageLifeLeech", "PhysicalDamageLifeLeech", "LightningDamageLifeLeech", "ColdDamageLifeLeech", "FireDamageLifeLeech", "ChaosDamageLifeLeech", "ElementalDamageLifeLeech" }, modType = "BASE", cfg = "skill" }, 
{ label = "主手", notFlag = "totem", flag = "weapon1Attack", modName = { "DamageLeech", "DamageLifeLeech", "PhysicalDamageLifeLeech", "LightningDamageLifeLeech", "ColdDamageLifeLeech", "FireDamageLifeLeech", "ChaosDamageLifeLeech", "ElementalDamageLifeLeech" }, modType = "BASE", cfg = "weapon1" }, 
{ label = "副手", notFlag = "totem", flag = "weapon2Attack", modName = { "DamageLeech", "DamageLifeLeech", "PhysicalDamageLifeLeech", "LightningDamageLifeLeech", "ColdDamageLifeLeech", "FireDamageLifeLeech", "ChaosDamageLifeLeech", "ElementalDamageLifeLeech" }, modType = "BASE", cfg = "weapon2" }, 
{ label = "图腾加成", flag = "totem", modName = { "DamageLifeLeechToPlayer" }, modType = "BASE", cfg = "skill" },
{ label = "敌人加成", modName = { "SelfDamageLifeLeech" }, modType = "BASE", enemy = true },
	}, },
{ label = "每次击中偷取生命", flagList = { "leechLife", "showAverage" }, { format = "{1:output:LifeLeechPerHit}", 
		{ breakdown = "LifeLeech" },
{ label = "玩家加成", notFlagList = { "totem", "attack" }, modName = { "DamageLeech", "DamageLifeLeech", "PhysicalDamageLifeLeech", "LightningDamageLifeLeech", "ColdDamageLifeLeech", "FireDamageLifeLeech", "ChaosDamageLifeLeech", "ElementalDamageLifeLeech" }, modType = "BASE", cfg = "skill" }, 
{ label = "主手", notFlag = "totem", flag = "weapon1Attack", modName = { "DamageLeech", "DamageLifeLeech", "PhysicalDamageLifeLeech", "LightningDamageLifeLeech", "ColdDamageLifeLeech", "FireDamageLifeLeech", "ChaosDamageLifeLeech", "ElementalDamageLifeLeech" }, modType = "BASE", cfg = "weapon1" }, 
{ label = "副手", notFlag = "totem", flag = "weapon2Attack", modName = { "DamageLeech", "DamageLifeLeech", "PhysicalDamageLifeLeech", "LightningDamageLifeLeech", "ColdDamageLifeLeech", "FireDamageLifeLeech", "ChaosDamageLifeLeech", "ElementalDamageLifeLeech" }, modType = "BASE", cfg = "weapon2" }, 
{ label = "图腾加成", flag = "totem", modName = { "DamageLifeLeechToPlayer" }, modType = "BASE", cfg = "skill" },
{ label = "敌人加成", modName = { "SelfDamageLifeLeech" }, modType = "BASE", enemy = true },
	}, },
{ label = "生命击回速率", notFlag = "showAverage", haveOutput = "LifeOnHitRate", { format = "{1:output:LifeOnHitRate}", 
{ label = "玩家加成", notFlag = "attack", modName = "LifeOnHit", modType = "BASE", cfg = "skill" }, 
{ label = "主手", flag = "weapon1Attack", modName = "LifeOnHit", modType = "BASE", cfg = "weapon1" }, 
{ label = "副手", flag = "weapon2Attack", modName = "LifeOnHit", modType = "BASE", cfg = "weapon2" }, 
{ label = "敌人加成", modName = { "SelfLifeOnHit" }, modType = "BASE", cfg = "skill", enemy = true },
	}, },
{ label = "每次击中回复生命", flag = "showAverage", haveOutput = "LifeOnHit", { format = "{1:output:LifeOnHit}", 
{ label = "玩家加成", notFlag = "attack", modName = "LifeOnHit", modType = "BASE", cfg = "skill" }, 
{ label = "主手", flag = "weapon1Attack", modName = "LifeOnHit", modType = "BASE", cfg = "weapon1" }, 
{ label = "副手", flag = "weapon2Attack", modName = "LifeOnHit", modType = "BASE", cfg = "weapon2" }, 
{ label = "敌人加成", modName = { "SelfLifeOnHit" }, modType = "BASE", cfg = "skill", enemy = true },
	}, },
{ label = "最大能量护盾偷取", flag = "leechES", { format = "{1:output:MaxEnergyShieldLeechRate}", 
		{ breakdown = "MaxEnergyShieldLeechRate" },
		{ modName = "MaxEnergyShieldLeechRate" },
	}, },
{ label = "能量护盾偷取速率", flag = "leechES", notFlag = "showAverage", { format = "{1:output:EnergyShieldLeechRate}", 
		{ breakdown = "EnergyShieldLeech" },
{ label = "玩家加成", notFlagList = { "totem", "attack" }, modName = { "DamageLeech", "DamageLifeLeech", "PhysicalDamageLifeLeech", "LightningDamageLifeLeech", "ColdDamageLifeLeech", "FireDamageLifeLeech", "ChaosDamageLifeLeech", "ElementalDamageLifeLeech" }, modType = "BASE", cfg = "skill" }, 
{ label = "主手", notFlag = "totem", flag = "weapon1Attack", modName = { "DamageLeech", "DamageLifeLeech", "PhysicalDamageLifeLeech", "LightningDamageLifeLeech", "ColdDamageLifeLeech", "FireDamageLifeLeech", "ChaosDamageLifeLeech", "ElementalDamageLifeLeech" }, modType = "BASE", cfg = "weapon1" }, 
{ label = "副手", notFlag = "totem", flag = "weapon2Attack", modName = { "DamageLeech", "DamageLifeLeech", "PhysicalDamageLifeLeech", "LightningDamageLifeLeech", "ColdDamageLifeLeech", "FireDamageLifeLeech", "ChaosDamageLifeLeech", "ElementalDamageLifeLeech" }, modType = "BASE", cfg = "weapon2" }, 
{ label = "图腾加成", flag = "totem", modName = { "DamageLifeLeechToPlayer" }, modType = "BASE", cfg = "skill" },
{ label = "敌人加成", modName = { "SelfDamageLifeLeech" }, modType = "BASE", enemy = true },
	}, },
{ label = "每次击中偷取能量护盾", flagList = { "leechES", "showAverage" }, { format = "{1:output:EnergyShieldLeechPerHit}",
		{ breakdown = "EnergyShieldLeech" },
{ label = "玩家加成", notFlagList = { "totem", "attack" }, modName = { "DamageEnergyShieldLeech", "PhysicalDamageEnergyShieldLeech", "LightningDamageEnergyShieldLeech", "ColdDamageEnergyShieldLeech", "FireDamageEnergyShieldLeech", "ChaosDamageEnergyShieldLeech", "ElementalDamageEnergyShieldLeech" }, modType = "BASE", cfg = "skill" }, 
{ label = "主手", notFlag = "totem", flag = "weapon1Attack", modName = { "DamageEnergyShieldLeech", "PhysicalDamageEnergyShieldLeech", "LightningDamageEnergyShieldLeech", "ColdDamageEnergyShieldLeech", "FireDamageEnergyShieldLeech", "ChaosDamageEnergyShieldLeech", "ElementalDamageEnergyShieldLeech" }, modType = "BASE", cfg = "weapon1" }, 
{ label = "副手", notFlag = "totem", flag = "weapon2Attack", modName = { "DamageEnergyShieldLeech", "PhysicalDamageEnergyShieldLeech", "LightningDamageEnergyShieldLeech", "ColdDamageEnergyShieldLeech", "FireDamageEnergyShieldLeech", "ChaosDamageEnergyShieldLeech", "ElementalDamageEnergyShieldLeech" }, modType = "BASE", cfg = "weapon2" }, 
{ label = "图腾加成", flag = "totem", modName = { "DamageEnergyShieldLeechToPlayer" }, modType = "BASE", cfg = "skill" },
{ label = "敌人加成", modName = { "SelfDamageEnergyShieldLeech" }, modType = "BASE", enemy = true },
	}, },
{ label = "能量护盾击回速率", notFlag = "showAverage", haveOutput = "EnergyShieldOnHitRate", { format = "{1:output:EnergyShieldOnHitRate}", 
{ label = "玩家加成", notFlag = "attack", modName = "EnergyShieldOnHit", modType = "BASE", cfg = "skill" }, 
{ label = "主手", flag = "weapon1Attack", modName = "EnergyShieldOnHit", modType = "BASE", cfg = "weapon1" }, 
{ label = "副手", flag = "weapon2Attack", modName = "EnergyShieldOnHit", modType = "BASE", cfg = "weapon2" }, 
{ label = "敌人加成", modName = { "SelfEnergyShieldOnHit" }, modType = "BASE", enemy = true },
	}, },
{ label = "每次击回能量护盾", flag = "showAverage", haveOutput = "EnergyShieldOnHit", { format = "{1:output:EnergyShieldOnHit}", 
{ label = "玩家加成", notFlag = "attack", modName = "EnergyShieldOnHit", modType = "BASE", cfg = "skill" }, 
{ label = "主手", flag = "weapon1Attack", modName = "EnergyShieldOnHit", modType = "BASE", cfg = "weapon1" }, 
{ label = "副手", flag = "weapon2Attack", modName = "EnergyShieldOnHit", modType = "BASE", cfg = "weapon2" }, 
{ label = "敌人加成", modName = { "SelfEnergyShieldOnHit" }, modType = "BASE", cfg = "skill", enemy = true },
	}, },
{ label = "最大魔力偷取", flag = "leechMana", { format = "{1:output:MaxManaLeechRate}", 
		{ breakdown = "MaxManaLeechRate" },
		{ modName = "MaxManaLeechRate" },
	}, },
{ label = "魔力偷取速率", flag = "leechMana", notFlag = "showAverage", { format = "{1:output:ManaLeechRate}", 
		{ breakdown = "ManaLeech" }, 
{ label = "玩家加成", notFlag = "attack", modName = { "DamageLeech", "DamageManaLeech", "PhysicalDamageManaLeech", "LightningDamageManaLeech", "ColdDamageManaLeech", "FireDamageManaLeech", "ChaosDamageManaLeech", "ElementalDamageManaLeech" }, modType = "BASE", cfg = "skill" }, 
{ label = "主手", flag = "weapon1Attack", modName = { "DamageLeech", "DamageManaLeech", "PhysicalDamageManaLeech", "LightningDamageManaLeech", "ColdDamageManaLeech", "FireDamageManaLeech", "ChaosDamageManaLeech", "ElementalDamageManaLeech" }, modType = "BASE", cfg = "weapon1" }, 
{ label = "副手", flag = "weapon2Attack", modName = { "DamageLeech", "DamageManaLeech", "PhysicalDamageManaLeech", "LightningDamageManaLeech", "ColdDamageManaLeech", "FireDamageManaLeech", "ChaosDamageManaLeech", "ElementalDamageManaLeech" }, modType = "BASE", cfg = "weapon2" }, 
{ label = "敌人加成", modName = { "SelfDamageManaLeech" }, modType = "BASE", cfg = "skill", enemy = true },
	}, },
{ label = "每次击中魔力偷取", flagList = { "leechMana", "showAverage" }, { format = "{1:output:ManaLeechPerHit}", 
		{ breakdown = "ManaLeech" }, 
{ label = "玩家加成", notFlag = "attack", modName = { "DamageLeech", "DamageManaLeech", "PhysicalDamageManaLeech", "LightningDamageManaLeech", "ColdDamageManaLeech", "FireDamageManaLeech", "ChaosDamageManaLeech", "ElementalDamageManaLeech" }, modType = "BASE", cfg = "skill" }, 
{ label = "主手", flag = "weapon1Attack", modName = { "DamageLeech", "DamageManaLeech", "PhysicalDamageManaLeech", "LightningDamageManaLeech", "ColdDamageManaLeech", "FireDamageManaLeech", "ChaosDamageManaLeech", "ElementalDamageManaLeech" }, modType = "BASE", cfg = "weapon1" }, 
{ label = "副手", flag = "weapon2Attack", modName = { "DamageLeech", "DamageManaLeech", "PhysicalDamageManaLeech", "LightningDamageManaLeech", "ColdDamageManaLeech", "FireDamageManaLeech", "ChaosDamageManaLeech", "ElementalDamageManaLeech" }, modType = "BASE", cfg = "weapon2" }, 
{ label = "敌人加成", modName = { "SelfDamageManaLeech" }, modType = "BASE", enemy = true },
	}, },
{ label = "魔力击回速率", notFlag = "showAverage", haveOutput = "ManaOnHitRate", { format = "{1:output:ManaOnHitRate}", 
{ label = "玩家加成", notFlag = "attack", modName = "ManaOnHit", modType = "BASE", cfg = "skill" }, 
{ label = "主手", flag = "weapon1Attack", modName = "ManaOnHit", modType = "BASE", cfg = "weapon1" }, 
{ label = "副手", flag = "weapon2Attack", modName = "ManaOnHit", modType = "BASE", cfg = "weapon2" }, 
{ label = "敌人加成", modName = { "SelfManaOnHit" }, modType = "BASE", cfg = "skill", enemy = true },
	}, },
{ label = "每次击中回复魔力", flag = "showAverage", haveOutput = "ManaOnHit", { format = "{1:output:ManaOnHit}",
{ label = "玩家加成", notFlag = "attack", modName = "ManaOnHit", modType = "BASE", cfg = "skill" }, 
{ label = "主手", flag = "weapon1Attack", modName = "ManaOnHit", modType = "BASE", cfg = "weapon1" }, 
{ label = "副手", flag = "weapon2Attack", modName = "ManaOnHit", modType = "BASE", cfg = "weapon2" }, 
{ label = "敌人加成", modName = { "SelfManaOnHit" }, modType = "BASE", cfg = "skill", enemy = true },
	}, },
} },
{ 1, "MiscEffects", 1, "其他效果", colorCodes.OFFENCE, {
{ label = "感电几率", flag = "shock", { format = "{0:output:ShockChance}%", 
		{ breakdown = "MainHand.ShockChance" },
		{ breakdown = "OffHand.ShockChance" },
		{ breakdown = "ShockChance" },
{ label = "玩家加成", modName = "EnemyShockChance", cfg = "skill" },
{ label = "敌人加成", modName = "SelfShockChance", enemy = true },
	}, },
{ label = "感电持续时间加成", flag = "shock", { format = "x {2:output:ShockDurationMod}", 
		{ breakdown = "MainHand.ShockDPS" },
		{ breakdown = "OffHand.ShockDPS" },
		{ breakdown = "ShockDPS" },
{ label = "玩家加成", modName = "EnemyShockDuration", cfg = "skill" }, 
{ label = "敌人加成", modName = "SelfShockDuration", enemy = true }, 
	}, },
{ label = "冰冻几率", flag = "freeze", { format = "{0:output:FreezeChance}%", 
		{ breakdown = "MainHand.FreezeChance" }, 
		{ breakdown = "OffHand.FreezeChance" }, 
		{ breakdown = "FreezeChance" }, 
{ label = "玩家加成", modName = "EnemyFreezeChance", cfg = "skill" }, 
{ label = "敌人加成", modName = "SelfFreezeChance", enemy = true },
	}, },
{ label = "冰冻持续时间加成", flag = "freeze", { format = "x {2:output:FreezeDurationMod}", 
		{ breakdown = "MainHand.FreezeDPS" }, 
		{ breakdown = "OffHand.FreezeDPS" },
		{ breakdown = "FreezeDPS" },
{ label = "玩家加成", modName = "EnemyFreezeDuration", cfg = "skill" },
{ label = "敌人加成", modName = "SelfFreezeDuration", enemy = true },
	}, },
{ label = "晕眩门槛", flag = "hit", notFlag = "attack", { format = "x {2:output:EnemyStunThresholdMod}", { modName = "EnemyStunThreshold", cfg = "skill" }, }, },
{ label = "晕眩持续时间", flag = "hit", notFlag = "attack", { format = "{2:output:EnemyStunDuration}s", 
		{ breakdown = "EnemyStunDuration" }, 
{ label = "玩家加成", modName = { "EnemyStunDuration" }, cfg = "skill" },
{ label = "敌人加成", modName = { "StunRecovery" }, enemy = true },
	}, },
{ label = "主手晕眩门槛", bgCol = colorCodes.MAINHANDBG, flagList = {"hit","weapon1Attack"}, { format = "x {2:output:MainHand.EnemyStunThresholdMod}", { modName = "EnemyStunThreshold", cfg = "weapon1" }, }, },
{ label = "主手晕眩持续时间", bgCol = colorCodes.MAINHANDBG, flagList = {"hit","weapon1Attack"}, { format = "{2:output:MainHand.EnemyStunDuration}s", 
		{ breakdown = "MainHand.EnemyStunDuration" }, 
{ label = "玩家加成", modName = { "EnemyStunDuration" }, cfg = "weapon1" },
{ label = "敌人加成", modName = { "StunRecovery" }, enemy = true },
	}, },
{ label = "副手晕眩门槛", bgCol = colorCodes.OFFHANDBG, flagList = {"hit","weapon2Attack"}, { format = "x {2:output:OffHand.EnemyStunThresholdMod}", { modName = "EnemyStunThreshold", cfg = "weapon2" }, }, },
{ label = "副手晕眩持续时间", bgCol = colorCodes.OFFHANDBG, flagList = {"hit","weapon2Attack"}, { format = "{2:output:OffHand.EnemyStunDuration}s", 
		{ breakdown = "OffHand.EnemyStunDuration" }, 
{ label = "玩家加成", modName = { "EnemyStunDuration" }, cfg = "weapon2" },
{ label = "敌人加成", modName = { "StunRecovery" }, enemy = true },
	}, },
{ label = "击退几率", haveOutput = "KnockbackChance", { format = "{0:output:KnockbackChance}%", 
{ label = "玩家加成", modName = "EnemyKnockbackChance", cfg = "skill" }, 
{ label = "敌人加成", modName = "SelfKnockbackChance", enemy = true },
	}, },
{ label = "击退距离", haveOutput = "KnockbackChance", { format = "{0:output:KnockbackDistance}", 
		{ breakdown = "KnockbackDistance" },
		{ modName = "EnemyKnockbackDistance", cfg = "skill" }, 
	}, },
{ label = "主手击退几率", bgCol = colorCodes.MAINHANDBG, haveOutput = "MainHand.KnockbackChance", { format = "{0:output:MainHand.KnockbackChance}%", 
{ label = "玩家加成", modName = "EnemyKnockbackChance", cfg = "weapon1" },
{ label = "敌人加成", modName = "SelfKnockbackChance", enemy = true },
	}, },
{ label = "主手击退距离", bgCol = colorCodes.MAINHANDBG, haveOutput = "MainHand.KnockbackChance", { format = "{0:output:MainHand.KnockbackDistance}",
		{ breakdown = "MainHand.KnockbackDistance" },
		{ modName = "EnemyKnockbackDistance", cfg = "weapon1" },
	}, },
{ label = "副手击退几率", bgCol = colorCodes.OFFHANDBG, haveOutput = "OffHand.KnockbackChance", { format = "{0:output:OffHand.KnockbackChance}%", 
{ label = "玩家加成", modName = "EnemyKnockbackChance", cfg = "weapon2" },
{ label = "敌人加成", modName = "SelfKnockbackChance", enemy = true },
	}, },
{ label = "副手击退距离", bgCol = colorCodes.OFFHANDBG, haveOutput = "OffHand.KnockbackChance", { format = "{0:output:OffHand.KnockbackDistance}",
		{ breakdown = "OffHand.KnockbackDistance" },
		{ modName = "EnemyKnockbackDistance", cfg = "weapon2" },
	}, },
{ label = "物品数量", { format = "{0:mod:1}%", { modName = "LootQuantity", modType = "INC", cfg = "skill" }, }, },
{ label = "物品稀有度", { format = "{0:mod:1}%", { modName = "LootRarity", modType = "INC", cfg = "skill" }, }, },
} },
{ 1, "Attributes", 2, "属性", colorCodes.NORMAL, {
	extra = colorCodes.STRENGTH.."{0:output:Str}^7, "..colorCodes.DEXTERITY.."{0:output:Dex}^7, "..colorCodes.INTELLIGENCE.."{0:output:Int}",
{ label = "力量", { format = "{0:output:Str}", { breakdown = "Str" }, { modName = "Str" }, }, },
{ label = "敏捷", { format = "{0:output:Dex}", { breakdown = "Dex" }, { modName = "Dex" }, }, },
{ label = "智慧", { format = "{0:output:Int}", { breakdown = "Int" }, { modName = "Int" }, }, },
{ label = "奉献", { format = "{0:output:Devotion}", { breakdown = "Devotion" }, { modName = "Devotion" }, }, },
{ notFlag = "minionSkill", label = "力量需求", { format = "{output:ReqStrString}", { breakdown = "ReqStr" }, }, },
{ notFlag = "minionSkill", label = "敏捷需求", { format = "{output:ReqDexString}", { breakdown = "ReqDex" }, }, },
{ notFlag = "minionSkill", label = "智慧需求", { format = "{output:ReqIntString}", { breakdown = "ReqInt" }, }, },
} },
{ 1, "Life", 2, "生命", colorCodes.DEFENCE, {
	extra = "{0:output:LifeUnreserved}/{0:output:Life}",
{ label = "从装备获得", { format = "{0:mod:1}", { modName = "Life", modType = "BASE", modSource = "Item" }, }, },
{ label = "天赋树的总【提高】", { format = "{0:mod:1}%", { modName = "Life", modType = "INC", modSource = "Tree" }, }, },
{ label = "总基础", { format = "{0:mod:1}", { modName = "Life", modType = "BASE" }, }, },
{ label = "总【提高】", { format = "{0:mod:1}%", { modName = "Life", modType = "INC", }, }, },
{ label = "总【额外提高】", { format = "{0:mod:1}%", { modName = "Life", modType = "MORE", }, }, },
{ label = "总", { format = "{0:output:Life}", { breakdown = "Life" }, }, },
{ label = "保留", { format = "{0:output:LifeReserved} ({0:output:LifeReservedPercent}%)", { breakdown = "LifeReserved" }, }, },
{ label = "未保留", { format = "{0:output:LifeUnreserved} ({0:output:LifeUnreservedPercent}%)" }, },
{ label = "回复", { format = "{1:output:LifeRegen} ({1:output:LifeRegenPercent}%)", 
{ label = "源", modName = { "LifeRegen", "LifeRegenPercent", "LifeDegen" }, modType = "BASE" }, 
{ label = "回复加成", modName = "LifeRecovery" },
	}, },
} },
{ 1, "Mana", 2, "魔力", colorCodes.DEFENCE, {
	extra = "{0:output:ManaUnreserved}/{0:output:Mana}",
	notFlag = "minionSkill",
{ label = "从装备获得", { format = "{0:mod:1}", { modName = "Mana", modType = "BASE", modSource = "Item" }, }, },
{ label = "天赋树的总【提高】", { format = "{0:mod:1}%", { modName = "Mana", modType = "INC", modSource = "Tree" }, }, },
{ label = "总基础", { format = "{0:mod:1}", { modName = "Mana", modType = "BASE" }, }, },
{ label = "总【提高】", { format = "{0:mod:1}%", { modName = "Mana", modType = "INC" }, }, },
{ label = "总", { format = "{0:output:Mana}", { breakdown = "Mana" }, }, },
{ label = "保留", { format = "{0:output:ManaReserved} ({0:output:ManaReservedPercent}%)", { breakdown = "ManaReserved" }, }, },
{ label = "未保留", { format = "{0:output:ManaUnreserved} ({0:output:ManaUnreservedPercent}%)" }, },
{ label = "提高回复", { format = "{0:mod:1}%", { modName = "ManaRegen", modType = "INC" }, }, },
{ label = "回复", { format = "{1:output:ManaRegen}", 
		{ breakdown = "ManaRegen" }, 
{ label = "源", modName = { "ManaRegen", "ManaRegenPercent" }, modType = "BASE" },
{ label = "回复加成", modName = "ManaRecovery" },
	}, },
} },
{ 1, "EnergyShield", 2, "能量护盾", colorCodes.DEFENCE, {
	extra = "{0:output:EnergyShield}",
{ label = "从护具获得", { format = "{0:output:Gear:EnergyShield}", }, },
{ label = "全域基础", { format = "{0:mod:1}", { modName = "EnergyShield", modType = "BASE" }, }, },
{ label = "天赋树的总【提高】", { format = "{0:mod:1}%", { modName = "EnergyShield", modType = "INC", modSource = "Tree" }, }, },
{ label = "总【提高】", { format = "{0:mod:1}%", { modName = { "EnergyShield", "Defences" }, modType = "INC" }, }, },
{ label = "总【额外提高】", { format = "{0:mod:1}%", { modName = { "EnergyShield", "Defences" }, modType = "MORE" }, }, },
{ label = "总", { format = "{0:output:EnergyShield}", { breakdown = "EnergyShield" }, }, },
{ label = "回复速率", { format = "{1:output:EnergyShieldRecharge}", 
		{ breakdown = "EnergyShieldRecharge" },
		{ modName = { "EnergyShieldRecharge", "EnergyShieldRecovery" }, },
	}, },
{ label = "充能延迟", { format = "{2:output:EnergyShieldRechargeDelay}s", 
		{ breakdown = "EnergyShieldRechargeDelay" },
		{ modName = "EnergyShieldRechargeFaster" },
	}, },
{ label = "回复", { format = "{1:output:EnergyShieldRegen} ({1:output:EnergyShieldRegenPercent}%)", 
{ label = "源", modName = { "EnergyShieldRegen", "EnergyShieldRegenPercent" }, modType = "BASE" }, 
{ label = "提高", modName = { "EnergyShieldRegen", "EnergyShieldRegenPercent" }, modType = "INC" }, 
{ label = "额外总提高", modName = { "EnergyShieldRegen", "EnergyShieldRegenPercent" }, modType = "MORE" }, 
{ label = "回复加成", modName = "EnergyShieldRecovery" },

	}, },
} },
{ 1, "Armour", 3, "护甲", colorCodes.DEFENCE, {
	extra = "{0:output:Armour}",
{ label = "从护具获得", { format = "{0:output:Gear:Armour}" }, },
{ label = "全域基础", { format = "{0:mod:1}", { modName = "Armour", modType = "BASE" }, }, },
{ label = "天赋树的总【提高】", { format = "{0:mod:1}%", { modName = { "Armour", "ArmourAndEvasion" }, modType = "INC", modSource = "Tree", }, }, },
{ label = "总【提高】", { format = "{0:mod:1}%", { modName = { "Armour", "ArmourAndEvasion", "Defences" }, modType = "INC" }, }, },
{ label = "总【额外提高】", { format = "{0:mod:1}%", { modName = { "Armour", "ArmourAndEvasion", "Defences" }, modType = "MORE" }, }, },
{ label = "总", { format = "{0:output:Armour}", { breakdown = "Armour" }, }, },
{ label = "物理伤害减伤", { format = "{0:output:PhysicalDamageReduction}%", 
		{ breakdown = "PhysicalDamageReduction" },
		{ modName = { "PhysicalDamageReduction", "PhysicalDamageReductionWhenHit" } }, 
	}, },
} },
{ 1, "Evasion", 3, "闪避", colorCodes.DEFENCE, {
	extra = "{0:output:Evasion}",
{ label = "从护具获得", { format = "{0:output:Gear:Evasion}", }, },
{ label = "全域基础", { format = "{0:mod:1}", { modName = "Evasion", modType = "BASE" }, }, },
{ label = "天赋树的总【提高】", { format = "{0:mod:1}%", { modName = { "Evasion", "ArmourAndEvasion" }, modType = "INC", modSource = "Tree" }, }, },
{ label = "总【提高】", { format = "{0:mod:1}%", { modName = { "Evasion", "ArmourAndEvasion", "Defences" }, modType = "INC" }, }, },
{ label = "总【额外提高】", { format = "{0:mod:1}%", { modName = { "Evasion", "ArmourAndEvasion", "Defences" }, modType = "MORE" }, }, },
{ label = "总", { format = "{0:output:Evasion}", { breakdown = "Evasion" }, }, },
{ label = "闪避几率", { format = "{0:output:EvadeChance}%", 
		{ breakdown = "EvadeChance" },
		{ modName = { "CannotEvade" } },
{ label = "敌人加成", modName = { "Accuracy", "HitChance" }, enemy = true },
	}, },
} },
{ 1, "Resist", 3, "抗性", colorCodes.DEFENCE, {
	extra = colorCodes.FIRE.."{0:output:FireResist}+{0:output:FireResistOverCap}^7/"..colorCodes.COLD.."{0:output:ColdResist}+{0:output:ColdResistOverCap}^7/"..colorCodes.LIGHTNING.."{0:output:LightningResist}+{0:output:LightningResistOverCap}",
{ label = "火焰抗性", { format = "{0:output:FireResist}% (+{0:output:FireResistOverCap}%)",
		{ breakdown = "FireResist" }, 
		{ modName = { "FireResistMax", "FireResist", "ElementalResist" }, },
	}, },
{ label = "冰霜抗性", { format = "{0:output:ColdResist}% (+{0:output:ColdResistOverCap}%)", 
		{ breakdown = "ColdResist" },
		{ modName = { "ColdResistMax", "ColdResist", "ElementalResist" }, },
	}, },
{ label = "闪电抗性", { format = "{0:output:LightningResist}% (+{0:output:LightningResistOverCap}%)",
		{ breakdown = "LightningResist" },
		{ modName = { "LightningResistMax", "LightningResist", "ElementalResist" }, },
	}, },
{ label = "混沌抗性", { format = "{0:output:ChaosResist}% (+{0:output:ChaosResistOverCap}%)",
		{ breakdown = "ChaosResist" },
		{ modName = { "ChaosResistMax", "ChaosResist" }, }, 
	}, },
} },
{ 1, "DamageTaken", 3, "伤害承受", colorCodes.DEFENCE, {
{ label = "物理 击中/持续伤害", { format = "x {2:output:PhysicalTakenHitMult} / x {2:output:PhysicalTakenDotMult}", 
		{ breakdown = "PhysicalTakenHitMult" }, 
		{ breakdown = "PhysicalTakenDotMult" },
		{ modName = { "DamageTaken", "DamageTakenWhenHit", "DamageTakenOverTime", "PhysicalDamageTaken", "PhysicalDamageTakenWhenHit", "PhysicalDamageTakenOverTime", "PhysicalDamageTakenAsFire", "PhysicalDamageTakenAsCold", "PhysicalDamageTakenAsLightning", "PhysicalDamageTakenAsChaos" } },
	}, },
{ label = "火焰 击中/持续伤害", { format = "x {2:output:FireTakenHitMult} / x {2:output:FireTakenDotMult}",
		{ breakdown = "FireTakenHitMult" },
		{ breakdown = "FireTakenDotMult" },
		{ modName = { "DamageTaken", "DamageTakenWhenHit", "DamageTakenOverTime", "FireDamageTaken", "FireDamageTakenWhenHit", "FireDamageTakenOverTime", "ElementalDamageTaken", "ElementalDamageTakenWhenHit", "ElementalDamageTakenOverTime", "FireDamageTakenAsPhysical", "FireDamageDamageTakenAsCold", "FireDamageTakenAsLightning", "FireDamageTakenAsChaos", "ElementalDamageTakenAsPhysical", "ElementalDamageTakenAsChaos" } },
	}, },
{ label = "冰霜 击中/持续伤害", { format = "x {2:output:ColdTakenHitMult} / x {2:output:ColdTakenDotMult}",
		{ breakdown = "ColdTakenHitMult" },
		{ breakdown = "ColdTakenDotMult" },
		{ modName = { "DamageTaken", "DamageTakenWhenHit", "DamageTakenOverTime", "ColdDamageTaken", "ColdDamageTakenWhenHit", "ColdDamageTakenOverTime", "ElementalDamageTaken", "ElementalDamageTakenWhenHit", "ElementalDamageTakenOverTime", "ColdDamageTakenAsPhysical", "ColdDamageTakenAsFire", "ColdDamageTakenAsLightning", "ColdDamageTakenAsChaos", "ElementalDamageTakenAsPhysical", "ElementalDamageTakenAsChaos" } },
	}, },
{ label = "闪电 击中/持续伤害", { format = "x {2:output:LightningTakenHitMult} / x {2:output:LightningTakenDotMult}",
		{ breakdown = "LightningTakenHitMult" },
		{ breakdown = "LightningTakenDotMult" },
		{ modName = { "DamageTaken", "DamageTakenWhenHit", "DamageTakenOverTime", "LightningDamageTaken", "LightningDamageTakenWhenHit", "LightningDamageTakenOverTime", "ElementalDamageTaken", "ElementalDamageTakenWhenHit", "ElementalDamageTakenOverTime", "LightningDamageTakenAsPhysical", "LightningDamageTakenAsFire", "LightningDamageTakenAsCold", "LightningDamageTakenAsChaos", "ElementalDamageTakenAsPhysical", "ElementalDamageTakenAsChaos" } },
	}, },
{ label = "混沌 击中/持续伤害", { format = "x {2:output:ChaosTakenHitMult} / x {2:output:ChaosTakenDotMult}",
		{ breakdown = "ChaosTakenHitMult" },
		{ breakdown = "ChaosTakenDotMult" },
		{ modName = { "DamageTaken", "DamageTakenWhenHit", "DamageTakenOverTime", "ChaosDamageTaken", "ChaosDamageTakenWhenHit", "ChaosDamageTakenOverTime", "ChaosDamageTakenAsPhysical", "ChaosDamageTakenAsFire", "ChaosDamageTakenAsCold", "ChaosDamageTakenAsLightning" } },
	}, },
{ label = "心灵升华", haveOutput = "MindOverMatter", { format = "{0:output:MindOverMatter}%", 
		{ breakdown = "MindOverMatter" }, 
		{ modName = "DamageTakenFromManaBeforeLife" }, 
	}, },
{ label = "总降低回复", haveOutput = "TotalDegen", { format = "{1:output:TotalDegen}", 
		{ breakdown = "TotalDegen" },
{ label = "源", modName = { "PhysicalDegen", "FireDegen", "ColdDegen", "LightningDegen", "ChaosDegen" }, modType = "BASE" },
	}, },
{ label = "实际生命回复", haveOutput = "NetLifeRegen", { format = "{1:output:NetLifeRegen}", { breakdown = "NetLifeRegen" }, }, },
{ label = "实际魔力回复", haveOutput = "NetManaRegen", { format = "{1:output:NetManaRegen}", { breakdown = "NetManaRegen" }, }, },
} },
{ 1, "MiscDefences", 3, "其他防御", colorCodes.DEFENCE, {
{ label = "移动速度", { format = "x {2:output:EffectiveMovementSpeedMod}", { breakdown = "EffectiveMovementSpeedMod" }, { modName = "MovementSpeed" }, }, },
{ label = "攻击躲避几率", { format = "{0:output:AttackDodgeChance}%", { modName = "AttackDodgeChance" }, }, },
{ label = "法术躲避几率", { format = "{0:output:SpellDodgeChance}%", { modName = "SpellDodgeChance" }, }, }, 
{ label = "攻击格挡几率", { format = "{0:output:BlockChance}%",
		{ breakdown = "BlockChance" },
		{ modName = "BlockChance" }, 
	}, },
{ label = "法术格挡几率", { format = "{0:output:SpellBlockChance}%", 
		{ breakdown = "SpellBlockChance" }, 
		{ modName = { "SpellBlockChance", "BlockChanceConv" }, },
	}, },
{ label = "近战伤害避免几率", { format = "{0:output:MeleeAvoidChance}%", { breakdown = "MeleeAvoidChance" }, }, },
{ label = "投射物避免几率", { format = "{0:output:ProjectileAvoidChance}%", { breakdown = "ProjectileAvoidChance" }, }, },
{ label = "法术避免几率", { format = "{0:output:SpellAvoidChance}%", { breakdown = "SpellAvoidChance" }, }, },
{ label = "晕眩避免几率", { format = "{0:output:StunAvoidChance}%", { modName = "AvoidStun" }, }, },
{ label = "晕眩持续时间", { format = "{2:output:StunDuration}s", 
		{ breakdown = "StunDuration" },
		{ modName = "StunRecovery" },
	}, },
{ label = "格挡持续时间", { format = "{2:output:BlockDuration}s", 
		{ breakdown = "BlockDuration" },
		{ modName = { "StunRecovery", "BlockRecovery" }, }, 
	}, },
{ label = "照亮范围加成", { format = "x {2:output:LightRadiusMod}", { breakdown = "LightRadiusMod" }, { modName = "LightRadius" }, }, },
} },
}
